<?php
require __DIR__ . '/vendor/autoload.php';

use ZATCA\EGS;

// Force JSON response
header('Content-Type: application/json');

// Read request body
$input = json_decode(file_get_contents('php://input'), true);

// Validate input
if (!$input || empty($input['company_name'])) {
    http_response_code(400);
    echo json_encode(['error' => 'company_name is required']);
    exit;
}

$companyName = $input['company_name'];

// Example EGS Unit (replace with dynamic if needed)
$egs_unit = [
    'uuid' => uniqid(),
    'custom_id' => 'EGS1-' . rand(100000000, 999999999),
    'model' => 'IOS',
    'CRN_number' => '300091581200003',
    'VAT_name' => $companyName,
    'VAT_number' => '300091581200003',
    'location' => [
        'city' => 'Riyadh',
        'city_subdivision' => 'Central',
        'street' => 'King Fahd Road',
        'plot_identification' => '0000',
        'building' => '0000',
        'postal_zone' => '12345',
    ],
    'branch_name' => 'Main Branch',
    'branch_industry' => 'Food',
    'cancelation' => [
        'cancelation_type' => 'INVOICE',
        'canceled_invoice_number' => '',
    ],
];

try {
    $egs = new EGS($egs_unit);
    $egs->production = false;

    // Generate keys & CSR
    list($private_key, $csr) = $egs->generateNewKeysAndCSR('Qr');

    // Request compliance certificate
    list($request_id, $binary_security_token, $secret) = $egs->issueComplianceCertificate('123456', $csr);

    echo json_encode([
        'status' => 'success',
        'request_id' => $request_id,
        'binary_security_token' => $binary_security_token,
        'secret' => $secret,
        'company_name' => $companyName,
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
