<?php
// index.php

// Turn on error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// error_reporting(0);
// ini_set('display_errors', 0);
// ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/php-error.log'); // store errors in a log file
ob_start(); 

require __DIR__ . '/vendor/autoload.php';

use ZATCA\EGS;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Label\Label;
use Endroid\QrCode\Writer\PngWriter;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel;

const ROOT_PATH = __DIR__;
date_default_timezone_set('UTC');

// Function to handle JSON response
// function json_response($data, $status = 200) {
//     header('Content-Type: application/json');
//     http_response_code($status);
//     echo json_encode($data);
//     exit;
// }
function json_response($data, $status = 200) {
    // Clean any previous output (warnings, echoes, etc.)
    if (ob_get_length()) ob_clean();

    header('Content-Type: application/json');
    http_response_code($status);
    echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

// Get the request method and path
$method = $_SERVER['REQUEST_METHOD'];
$request_uri = trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), '/');

// Check for POST request and JSON content type
if ($method !== 'POST' || (isset($_SERVER['CONTENT_TYPE']) && strpos($_SERVER['CONTENT_TYPE'], 'application/json') === false)) {
    json_response(['error' => 'Invalid request method or content type.'], 405);
}

// Get the raw POST data
$json_data = file_get_contents('php://input');
$request_data = json_decode($json_data, true);

// Recursively format numbers
array_walk_recursive($request_data, function (&$v) {
    if (is_numeric($v)) {
        // Use number_format to produce "1.15" as a string
        // If you want a JSON number, skip this and use option (1).
        $v = number_format((float)$v, 2, '.', '');
    }
});



// json_response([$request_data], 200);

// Routing based on the URI
switch ($request_uri) {
    case 'register-device':
        // --- Register Device Endpoint Logic ---
        if (!isset($request_data['egs_unit']) || !isset($request_data['otp'])) {
            json_response(['error' => 'Missing required fields: egs_unit or otp.'], 400);
        }

        $egs_unit = $request_data['egs_unit'];
        $otp = $request_data['otp'];
        $prodFlag = false;
        if (isset($egs_unit['production'])) {
            $prodFlag = filter_var($egs_unit['production'], FILTER_VALIDATE_BOOLEAN);
        }
        try {
            $egs = new EGS($egs_unit);
            // $egs->production = false;
            // dd($prodFlag);
            // json_response(['error' => $prodFlag], 500);
            $egs->production = $prodFlag;

            list($private_key, $csr) = $egs->generateNewKeysAndCSR('Qr');
            list($request_id, $binary_security_token, $secret) = $egs->issueComplianceCertificate($otp, $csr);

            json_response([
                'csr' => $csr,
                'request_id' => $request_id,
                'binary_security_token' => $binary_security_token,
                'secret' => $secret,
                'private_key' => $private_key
            ]);
        } catch (\Exception $e) {
            json_response(['error' => $e->getMessage()], 500);
        }
        break;

    case 'sign-invoice':
        // --- Sign Invoice Endpoint Logic ---
        $required_fields = ['invoice', 'egs_unit', 'binary_security_token', 'private_key', 'secret'];
        foreach ($required_fields as $field) {
            if (!isset($request_data[$field])) {
                json_response(['error' => "Missing required field: $field."], 500);
            }
        }

        $invoice = $request_data['invoice'];
        $egs_unit = $request_data['egs_unit'];
        $binary_security_token = $request_data['binary_security_token'];
        $private_key = $request_data['private_key'];
        $secret = $request_data['secret'];

        try {
            $egs = new EGS($egs_unit);
            $egs->production = false;


        // json_response([$invoice], 200);
            list($signed_invoice_string, $invoice_hash, $qr) = $egs->signInvoice($invoice, $egs_unit, $binary_security_token, $private_key);

            $invoiceCompliance = $egs->checkInvoiceCompliance($signed_invoice_string, $invoice_hash, $binary_security_token, $secret);
            $compliance_status = json_decode($invoiceCompliance, true);

            $qrCode = QrCode::create($qr)
                ->setEncoding(new Encoding('UTF-8'))
                ->setErrorCorrectionLevel(ErrorCorrectionLevel::High)
                ->setSize(300)
                ->setMargin(10)
                ->setForegroundColor(new Color(0, 0, 0))
                ->setBackgroundColor(new Color(255, 255, 255));

            $writer = new PngWriter();
            $qr_image_string = $writer->write($qrCode)->getString();
            $writer->write($qrCode)->saveToFile(__DIR__ . '/assets/phase-2.png');
            
            json_response([
                'invoice_hash' => $invoice_hash,
                'previous_invoice_hash' => $invoice['previous_invoice_hash'] ?? '',
                'invoice_counter_number' => $invoice['invoice_counter_number'] ?? '',  
                'invoice_serial_number' => $invoice['invoice_serial_number'] ?? '',
                
                'qr_string' => $qr,
                'qr_image_base64' => 'data:image/png;base64,' . base64_encode($qr_image_string),
                // 'qr_image_base64' => base64_encode($qr_image_string),
                'compliance_status' => $compliance_status,
                'signed_invoice_xml' => $signed_invoice_string,
                

            ]);
        } catch (\Exception $e) {
            // json_response(['error' => $e->getMessage()], 500);
        }
        break;
    // case 'sign-standard-invoice':
    //     // --- Sign Standard Invoice Endpoint Logic ---
    //     $required_fields = ['invoice', 'egs_unit', 'binary_security_token', 'private_key', 'secret'];
    //     foreach ($required_fields as $field) {
    //         if (!isset($request_data[$field])) {
    //             json_response(['error' => "Missing required field: $field."], 400);
    //         }
    //     }

    //     $invoice = $request_data['invoice'];
    //     $egs_unit = $request_data['egs_unit'];
    //     $binary_security_token = $request_data['binary_security_token'];
    //     $private_key = $request_data['private_key'];
    //     $secret = $request_data['secret'];

    //     try {
    //         $egs = new EGS($egs_unit);
    //         $egs->production = false;

    //         list($signed_invoice_string, $invoice_hash, $qr) = $egs->signStandardInvoice($invoice, $egs_unit, $binary_security_token, $private_key);
    //         $invoiceCompliance = $egs->checkInvoiceCompliance($signed_invoice_string, $invoice_hash, $binary_security_token, $secret);
    //         $compliance_status = json_decode($invoiceCompliance, true);

    //         // ...QR code logic...

    //         json_response([
    //             'invoice_hash' => $invoice_hash,
    //             'qr_string' => $qr,
    //             'compliance_status' => $compliance_status,
    //             'signed_invoice_xml' => $signed_invoice_string,
    //         ]);
    //     } catch (\Exception $e) {
    //         json_response(['error' => $e->getMessage()], 500);
    //     }
    //     break;
    default:
        // --- Default/Invalid Path ---
        json_response(['error' => 'Endpoint not found.'], 404);
        break;
}
?>