<?php
header("Content-Type: application/json");

// 1️⃣ Only POST allowed
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(["status" => false, "message" => "Only POST method is allowed"]);
    exit;
}

// 2️⃣ API Key check
$headers = getallheaders();
if (!isset($headers['X-API-KEY']) || $headers['X-API-KEY'] !== "your-secret-key") {
    http_response_code(401);
    echo json_encode(["status" => false, "message" => "Unauthorized"]);
    exit;
}

// 3️⃣ Read request body
$input = file_get_contents("php://input");
$data = json_decode($input, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    echo json_encode(["status" => false, "message" => "Invalid JSON"]);
    exit;
}

// Required fields check
if (empty($data['binary_security_token']) || empty($data['secret']) || empty($data['invoice'])) {
    http_response_code(400);
    echo json_encode(["status" => false, "message" => "binary_security_token, secret and invoice data are required"]);
    exit;
}

require __DIR__ . '/../vendor/autoload.php';
use ZATCA\EGS;

try {
    // Load saved EGS unit (same as register step, but could be persisted in DB)
    $egs_unit = [
        'uuid' => $data['uuid'] ?? 'default-uuid',
        'custom_id' => $data['custom_id'] ?? 'EGS1-0000',
        'model' => $data['model'] ?? 'IOS',
        'CRN_number' => $data['CRN_number'] ?? '',
        'VAT_name' => $data['VAT_name'] ?? '',
        'VAT_number' => $data['VAT_number'] ?? '',
        'location' => $data['location'] ?? [],
        'branch_name' => $data['branch_name'] ?? '',
        'branch_industry' => $data['branch_industry'] ?? '',
    ];

    $egs = new EGS($egs_unit);
    $egs->production = false; // sandbox mode

    // Restore security token + secret from request
    $binary_security_token = $data['binary_security_token'];
    $secret = $data['secret'];

    // 🔹 1. Prepare invoice data
    $invoiceData = $data['invoice'];

    // Example: issue invoice
    $response = $egs->issueInvoice($invoiceData, $binary_security_token, $secret);

    echo json_encode([
        "status" => true,
        "message" => "Invoice issued successfully",
        "invoice_request" => $invoiceData,
        "zatca_response" => $response
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "status" => false,
        "message" => "Internal server error",
        "error" => $e->getMessage()
    ]);
}
